local P1
local P2 

local musicrate = GAMESTATE:GetSongOptionsObject("ModsLevel_Song"):MusicRate()

local WideScale = function(AR4_3, AR16_9)
	-- return scale( SCREEN_WIDTH, 640, 854, AR4_3, AR16_9 )
	local w = 480 * PREFSMAN:GetPreference("DisplayAspectRatio")
	return scale( w, 640, 854, AR4_3, AR16_9 )
 end

local function isEditMode()
	local screen = SCREENMAN:GetTopScreen()
	if not screen then
	   return nil
	end
	local screen = SCREENMAN:GetTopScreen()	
	return (THEME:GetMetric(screen:GetName(), "Class") == "ScreenEdit")
end

return Def.ActorFrame{
  Name= "xtl_actor_kh",
  InitCommand= function(self)
	songName = GAMESTATE:GetCurrentSong():GetSongDir();
	
	sw = SCREEN_WIDTH
	sh = SCREEN_HEIGHT --shortcuts
	
	function Plr(pn)
		return _G['P'..pn]
	end
	
	function mod_do(str,pn)
		if pn then
			GAMESTATE:ApplyGameCommand('mod,'..str,pn)
		else
			GAMESTATE:ApplyGameCommand('mod,'..str)
		end
	end
	
end,
Def.Sprite{
    Name= "xtl_actor_b",
    OnCommand= cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomtowidth,SCREEN_WIDTH;zoomtoheight,SCREEN_HEIGHT;diffusealpha,0),
    Texture= "itg.png",
  },
  Def.Quad{
    Name= "xtl_actor_c",
    NameCommand= function(self) i_bg = self end,
    OnCommand= cmd(playcommand,"Name";stretchto,0,0,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,color('0,0,0,0');diffusealpha,0),
  },

  Def.Quad{
    Name= "xtl_actor_lh",
    InitCommand= cmd(visible,false),
    OnCommand= cmd(sleep,1000),
  },
  LoadActor('modhelpers.lua') .. {
    Name= "xtl_actor_mh",
    File= "modhelpers.lua",
  },
  LoadActor('easing.lua') .. {
    Name= "xtl_actor_nh",
    File= "easing.lua",
  },
  Def.Quad{
    Name= "xtl_actor_oh",
    InitCommand= function(self)
		
			checked = false;
		
			---------------------------------------------------------
			---------DOCUMENTATION-----------------------------------
			---------------------------------------------------------
			
			--function perframe( beat, endBeat )
				--return true if the current beat is between 'beat' and 'endBeat'
			
			--function mod_shader(beat,key,which)
				--turn on shader key at specified beat (up to 10 keys available, defined by 'which' = 0-9
				
			--function mod_insert(beat,len,mod,len_or_end,pn)
				--insert mod into beat mods table
			--function mod_insert2(time,len,mod,len_or_end,pn)
				--insert mod into time mods table
				
			--function mod_message(beat,msg,persistent)
				--insert something into the actions table.
				--msg can also be a function. If string, a message gets broadcast at that beat
				--if 'persistent' is true, message will run even if editor starts at a beat past it
				
			--function mod_blacklist(t,n)
				--check if number n occurs in table t
				--useful for doing 'every beat EXCEPT the contents of t'
				
			--function simple_m0d(beat,strength,mult,mod)
			--function simple_m0d2(beat,strength,mult,mod,pn)
			--function simple_m0d3(beat,strength,duration,bpm,mod,pn)
				--activate mods at specific beat but also deactivate them
				
			--function mod_wiggle(beat,num,div,amt,speed,mod,pn,first)
				--alternates a mod back and forth before resetting to 0
				
			--function mod_springt(time,strength,dur,mod,pn)
				--time-based per-frame alternating mod that decreases based on how much time is left.
					--think doorstopper
			
			--function mod_springt2(time,strength,dur,mod,pn)
				--time-based per-frame alternating mod
			
			--function mod_onebeat(beat,strength,pn)
				--turns on beat for the beat specified, at the desired strength	
			
			--function switcheroo_add(beat,which,speed,len,pn)
				--adds a column swap at the desired beat
			--[[	switcheroos = {normal = {0,0}, ldur = {0,0}, reset = {0,0},
					flip = {100,0}, rudl = {100,0}, invert = {0,100}, dlru = {0,100},
					ludr = {25,-75}, rdul = {75,75}, drlu = {25,125}, ulrd = {75,-125}, urld = {100,-100}}
			]]
			
			--use a variable called 'switcheroo_width' to change how much space is between each column
			--e.g. switcheroo_width = 2 for ayakashi
			
			--function mod_sugarkiller(beat,duration,speed,minstealth,maxstealth,pn)
				--portable version of the effect from sugarkill X
				
			--function doSpline(spd, axis, path, col)
				--draws spline 'path' in specified axis, for specific col. Offsets are *10000, but positions use *spd
				
			--function doSplineAll(spd, axis, path)
				--same as above, but for all columns
				--(faster performance than using doSpline 4 times due to more efficient concat)
			
			--function mindf_rotateAndCounter(xDegrees, yDegrees, zDegrees, player)
				--counteract euler rotations after rotating player in multiple axes, using a TON of math.
			
			
			---------------------------------------------------------
			--------END DOCUMENTATION--------------------------------
			---------------------------------------------------------
			
			local m = mod_insert
			local m2 = mod_message
			
			
			
			
			
			
			
			
			
			
			init_modsp1 = '';
			init_modsp2 = '';
			
			mod_plr = {};
			
			mod_firstSeenBeat = GAMESTATE:GetSongBeat(); --necessary to prevent long freezes
			
			
			
			
			
			
			
			
			
			
			
---------------------------------------------------------------------------------------
----------------------Begin tables 'n stuff--------------------------------------------
---------------------------------------------------------------------------------------

			--beat based mods
			--{beat_start, beat_end, mods, len_or_end, player_number}
			mods = {
				{1,99999,'*1 25% dark, *1 10% stealth, *1 50% Beat, *1 20% Tipsy', 'end'},
				--{0,9999,'*2 2x, *10000 -9999 cover','end'},
			}
			
			--switcheroos = {{0,0},{100,0},{0,100},{25,-75},{75,75},{25,125},{75,-125},{100,-100}}
			
			
			
			
			
			
			
			--time based mods
			mod_time = 0;
			--{time_start, time_end, mods, len_or_end, player_number}
			mods2 = {
				--{0,200.345,'3x','end',1},
			}
			
			
			
			
			
			--beat-based ease mods
			--{time_start, time_end, mod_start, mod_end, mod, len_or_end, ease_type, player_number, sustaintime, optional_param1, optional_param2}
			--valid ease types are:
				--linear
				--inQuad    outQuad    inOutQuad    outInQuad
				--inCubic   outCubic   inOutCubic   outInCubic
				--inQuart   outQuart   inOutQuart   outInQuart
				--inQuint   outQuint   inOutQuint   outInQuint
				--inSine    outSine    inOutSine    outInSine
				--inExpo    outExpo    inOutExpo    outInExpo
				--inCirc    outCirc    inOutCirc    outInCirc
				--inElastic outElastic inOutElastic outInElastic    --can take 2 optional parameters - amplitude & period
				--inBack    outBack    inOutBack    outInBack       --can take 1 optional parameter  - spring amount
				--inBounce  outBounce  inOutBounce  outInBounce
				
			mods_ease = {
			}
			
			i_startime = 0;
			
			--this is both a message broadcaster and a function runner
			--if you put {beat,'String'}, then 'String' is broadcast as a message on that beat
			--if you put {beat,function() somecode end}, then function() is run at that beat
			--see example on beat 32
			
			curaction = 1;
			--{beat,thing,persists}
			mod_actions = {
			
				{3,function()
				--	i_bg:diffusealpha(1);
				end,true},
			
				{1,'Fade'},
				{3,'Open'},

			--	{40,'OpenQ',true},
			--	{41,'I'},
				--{64,'Fade2'},
			--	{70,'I'},
				
				{72.75,'Breezy'},
				--{76,'Unfade'},
				
				
				{272, 'FoolMe'},
				{295.5, 'Fooled'},
				{295.6,'I'},
				{295.8, 'I2'},
				
			}
			
			
			
			
			
			
			
			
---------------------------------------------------------------------------------------
----------------------Sort the actions table-------------------------------------------
---------------------------------------------------------------------------------------
			
			function modtable_compare(a,b)
				return a[1] < b[1]
			end
			
			self:queuecommand('Update');
			
		end,
    OnCommand= cmd(visible,false),
    UpdateCommand= function(self)

			if GAMESTATE:GetSongBeat()>=0 and not checked then
			
				local ThingsToGrab = {'LifeP1','LifeP2','ScoreP1','ScoreP2','BPMDisplay','LifeFrame','ScoreFrame',
										'Lyrics','SongBackground','SongForeground','Overlay','Underlay'}
				local ThingsToHide = {'LifeP1','LifeP2','ScoreP1','ScoreP2','BPMDisplay','LifeFrame','ScoreFrame','Overlay','Underlay'}
				
				for i,v in ipairs(ThingsToGrab) do
					_G[v] = SCREENMAN:GetTopScreen():GetChild(v) or nil
				end
				
				for i,v in ipairs(ThingsToHide) do
					if _G[v] then _G[v]:visible(false) end
				end
				
				table.insert(mod_plr,SCREENMAN:GetTopScreen():GetChild('PlayerP1'));
				table.insert(mod_plr,SCREENMAN:GetTopScreen():GetChild('PlayerP2'));
			
				--name players, judgment and combo
				for pn=1,2 do
					_G['P'..pn] = SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn) or nil;
					if _G['P'..pn] then
						_G['jud'..pn] = _G['P'..pn]:GetChild('Judgment');
						_G['com'..pn] = _G['P'..pn]:GetChild('Combo');
					end
				end
				
				screen = SCREENMAN:GetTopScreen();
				if table.getn(mod_actions) > 1 then
					table.sort(mod_actions, modtable_compare)
				end
				checked = true; --let this only run once
				
			end

			local beat = GAMESTATE:GetSongBeat()
			
			
---------------------------------------------------------------------------------------
----------------------Begin table handlers---------------------------------------------
---------------------------------------------------------------------------------------
			
			disable = false;
			if disable ~= true and checked then
				
				-----------------------
				-- Player mod resets --
				-----------------------
				if beat > mod_firstSeenBeat+0.1 then -- performance coding!! --
					for i=1,2 do
						--mod_do('clearall',i)
					end
				end
				
				------------------------------------------------------------------------------
				-- custom mod reader by TaroNuke edited by WinDEU and re-stolen by TaroNuke --
				------------------------------------------------------------------------------
				if beat > mod_firstSeenBeat+0.1 then -- performance coding!! --
					for i,v in pairs(mods) do
						if v and table.getn(v) > 3 and v[1] and v[2] and v[3] and v[4] then
							if beat >=v[1] then
								if (v[4] == 'len' and beat <=v[1]+v[2]) or (v[4] == 'end' and beat <=v[2]) then
									if table.getn(v) == 5 then
										mod_do(v[3],v[5]);
									else
										mod_do(v[3]);
									end
								end
							end
						else
							v[1] = 0;
							v[2] = 0;
							v[3] = '';
							v[4] = 'error';
							SCREENMAN:SystemMessage('Bad mod in beat-based table (line '..i..')');
						end
					end
				end
				
				-----------------------------------------------------------------------------------------------------
				-- WinDEU's time-based len/end version of the #swag custom mod reader #teamproofofconcept (c) 2015 --
				-----------------------------------------------------------------------------------------------------
				if beat > mod_firstSeenBeat+0.1 then -- performance coding!! --
					for i,v in pairs(mods2) do
						if v and table.getn(v) > 3 and v[1] and v[2] and v[3] and v[4] then
							if mod_time >=v[1] then
								if (v[4] == 'len' and mod_time <=v[1]+v[2]) or (v[4] == 'end' and mod_time <=v[2]) then
									if table.getn(v) == 5 then
										mod_do(v[3],v[5]);
									else
										mod_do(v[3]);
									end
								end
							end
						else
							v[1] = 0;
							v[2] = 0;
							v[3] = 'error';
							v[4] = 'error';
							SCREENMAN:SystemMessage('Bad mod in time-based table (line '..i..')');
						end
					end
				end
				
				---------------------------------------------------
				-- ease mod reader v2                            --
				-- friendship ended with if wall                 --
				-- now functions as parameters is my best friend --
				---------------------------------------------------
				if beat > mod_firstSeenBeat+0.1 then -- performance coding!! --
					for i,v in pairs(mods_ease) do
						if v and table.getn(v) > 6 and v[1] and v[2] and v[3] and v[4] and v[5] and v[6] and v[7] then
							if beat >=v[1] then
								if (v[6] == 'len' and beat <=v[1]+v[2]) or (v[6] == 'end' and beat <=v[2]) then
									
									local duration = v[2];
									if v[6] == 'end' then duration = v[2] - v[1] end
									local curtime = beat - v[1]
									local diff = v[4] - v[3]
									local startstrength = v[3]
									local curve = v[7]
									local mod = v[5]
									
									local strength = curve(curtime, startstrength, diff, duration, v[10], v[11]) --extra parameters for back and elastic eases :eyes:
									
									if v[5] == 'xmod' then
										if table.getn(v) >= 8 then GAMESTATE:ApplyGameCommand('mod,*10000 '..strength..'x',v[8]);
										else GAMESTATE:ApplyGameCommand('mod,*10000 '..strength..'x'); end
									else
										if table.getn(v) >= 8 then GAMESTATE:ApplyGameCommand('mod,*10000 '..strength..' '..mod,v[8]);
										else GAMESTATE:ApplyGameCommand('mod,*10000 '..strength..' '..mod); end
									end
								elseif (v[9] and ((v[6] == 'len' and beat <=v[1]+v[2]+v[9]) or (v[6] == 'end' and beat <=v[9]))) then
									if v[5] == 'xmod' then
										if v[8] then GAMESTATE:ApplyGameCommand('mod,*10000 '..v[4]..'x', v[8]);
										else GAMESTATE:ApplyGameCommand('mod,*10000 '..v[4]..'x'); end
									else
										if v[8] then GAMESTATE:ApplyGameCommand('mod,*10000 '..v[4]..' '..v[5], v[8]);
										else GAMESTATE:ApplyGameCommand('mod,*10000 '..v[4]..' '..v[5]); end
									end
								end
							end
						else
							SCREENMAN:SystemMessage('Bad mod in beat-based ease table (line '..i..')');
						end
					end
				end
				
				--------------------
				-- Perframe stuff --
				--------------------
				
				
				
				---------------------------------------
				-- ACTION RPGS AINT GOT SHIT ON THIS --
				---------------------------------------
				if beat > mod_firstSeenBeat+0.1 then -- performance coding!! --
					while curaction<=table.getn(mod_actions) and GAMESTATE:GetSongBeat()>=mod_actions[curaction][1] do
						if mod_actions[curaction][3] or GAMESTATE:GetSongBeat() < mod_actions[curaction][1]+2 then
							if type(mod_actions[curaction][2]) == 'function' then
								mod_actions[curaction][2]()
							elseif type(mod_actions[curaction][2]) == 'string' then
								MESSAGEMAN:Broadcast(mod_actions[curaction][2]);
							end
						end
						curaction = curaction+1;
					end
				end
				
			end
			
			self:sleep(0.02);
			self:queuecommand('Update');

---------------------------------------------------------------------------------------
----------------------END DON'T TOUCH IT KIDDO-----------------------------------------
---------------------------------------------------------------------------------------
			
		end,
  },
 
  Def.Quad{
    Name= "xtl_actor_yh",
    Fade2MessageCommand= cmd(accelerate,6*60/50;diffusealpha,1),
    IMessageCommand= cmd(diffuse,color('0,0,0,1')),
	I2MessageCommand=function(self)
		self:linear(0.3):diffusealpha(0)
	end,
    OnCommand= cmd(stretchto,0,0,SCREEN_WIDTH,SCREEN_HEIGHT;diffusealpha,0),
    UnfadeMessageCommand= cmd(linear,1;diffusealpha,0),

  },
  Def.Sprite{
    Name= "xtl_actor_zh",
    IMessageCommand= cmd(zoom,10;decelerate,0.3;zoomx,1.5;zoomy,0),
    OnCommand= cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoom,0),
    Texture= "transition.png",
  },
  LoadActor("foolMe2.mp4")..{
	InitCommand = function(self)
	  local src_w = self:GetTexture():GetSourceWidth()
	  self:Center():zoom(_screen.w/WideScale(src_w*0.75,src_w)):addy(SCREEN_HEIGHT/10)
	  self:animate(false):loop(false):diffusealpha(0)
	end,
	FoolMeMessageCommand = function(self)
	  local src_w = self:GetTexture():GetSourceWidth()
	  self:visible(true)
	  self:animate(true):loop(true)
	  self:linear(2):diffusealpha(1)
	  self:rate( musicrate )
	end,
	Fooled2MessageCommand = function(self)
	 -- self:rate( musicrate*3 ):sleep(0.75):rate( musicrate)
	end,
	FooledMessageCommand = function(self)
	  self:linear(0.5):diffusealpha(0):animate(false):loop(false)
	end
},
  Def.Quad{
    Name= "xtl_actor_ph",
    OnCommand= cmd(stretchto,0,0,SCREEN_WIDTH,SCREEN_HEIGHT),
    OpenMessageCommand= cmd(sleep,6*60/50;linear,10*60/50;diffusealpha,0),
    OpenQMessageCommand= cmd(visible,false),
  },
  Def.Quad{
    Name= "xtl_actor_qh",
    OnCommand= cmd(stretchto,0,0,SCREEN_WIDTH,SCREEN_HEIGHT/2;diffuse,color('0,0,0,1')),
    OpenMessageCommand= cmd(linear,16*60/60;addy,-SCREEN_HEIGHT*0.4),
    OpenQMessageCommand= cmd(visible,false),
  },
  Def.Quad{
    Name= "xtl_actor_rh",
    OnCommand= cmd(stretchto,0,SCREEN_HEIGHT/2,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,color('0,0,0,1')),
    OpenMessageCommand= cmd(linear,16*60/60;addy,SCREEN_HEIGHT*0.4),
    OpenQMessageCommand= cmd(visible,false),
  },
  Def.Sprite{
    Name= "xtl_actor_sh",
    FadeMessageCommand= cmd(linear,120/225;diffuse,color('.3,.3,.3,1')),
    OnCommand= cmd(stretchto,0,0,SCREEN_WIDTH,SCREEN_HEIGHT;cropbottom,0.5;diffuse,color('0.5,0.5,0.5,1')),
    OpenMessageCommand= cmd(linear,16*60/50;addy,-SCREEN_HEIGHT*0.5-50;diffuse,color('0,0,0,1')),
    OpenQMessageCommand= cmd(visible,false),
    Texture= "itg.png",
  },
  Def.Sprite{
    Name= "xtl_actor_th",
    FadeMessageCommand= cmd(linear,120/225;diffuse,color('.3,.3,.3,1')),
    OnCommand= cmd(stretchto,0,0,SCREEN_WIDTH,SCREEN_HEIGHT;croptop,0.5;diffuse,color('0.5,0.5,0.5,1')),
    OpenMessageCommand= cmd(linear,16*60/50;addy,SCREEN_HEIGHT*0.5+50;diffuse,color('0,0,0,1')),
    OpenQMessageCommand= cmd(visible,false),
    Texture= "itg.png",
  },
  Def.Quad{
    Name= "xtl_actor_uh",
    OnCommand= cmd(stretchto,0,0,SCREEN_WIDTH,SCREEN_HEIGHT/2;diffuse,color('1,1,1,0');fadetop,0.4;croptop,0.6),
    OpenMessageCommand= cmd(diffusealpha,.4;linear,16*60/50;addy,-SCREEN_HEIGHT*0.5;diffusealpha,0.1),
    OpenQMessageCommand= cmd(visible,false),
  },
  Def.Quad{
    Name= "xtl_actor_vh",
    OnCommand= cmd(stretchto,0,SCREEN_HEIGHT/2,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,color('1,1,1,0');fadebottom,0.4;cropbottom,0.6),
    OpenMessageCommand= cmd(diffusealpha,.4;linear,16*60/50;addy,SCREEN_HEIGHT*0.5;diffusealpha,0.1),
    OpenQMessageCommand= cmd(visible,false),
  },
  Def.Sprite{
    Name= "xtl_actor_wh",
    OnCommand= cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;customtexturerect,0,0,4,4;blend,"BlendMode_Add";zoom,4;diffusealpha,0),
    OpenMessageCommand= cmd(linear,0.1;diffusealpha,0.1;linear,16*60/50;diffusealpha,0.1),
    Texture= "tex2.png",
  },
  Def.Sprite{
    Name= "xtl_actor_xh",
    OnCommand= cmd(stretchto,0,0,SCREEN_WIDTH,SCREEN_HEIGHT;diffusealpha,0),
    OpenMessageCommand= cmd(linear,0.1;diffusealpha,0.5),
    Texture= "vig.png",
  }


}
